// Title      : How to fuck CRC16, CRC32, CRC48 for Adinf, AVPInspector, etc.
// Status     : Freeware
// Author     : Zhengxi
// Compiler   : Watcom C 10.0b
// Target     : Win32 console application
// Libraries  : Nothing
// StartWork  : 08.12.98
// LastChange : 10.12.98

// modified   : 30-01-00 by Z0MBiE
// compiler   : borland C (but i hope any 32-bit C compiler)

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

typedef unsigned char   byte;
typedef unsigned short  word;
typedef unsigned long   dword;

#define MAGIC16    0xA001
#define MAGIC32    0xEDB88320

dword xcrc16( byte *ptr,
              dword  size,
              dword  crc )
{
    while(size-- != 0)
    {
        dword i;
        dword c=*ptr++;
        for( i=0; i<8; i++)
        {
            if( (crc^c)&1 )
                crc = (crc>>1) ^ MAGIC16;
            else
                crc = (crc>>1);
            c>>=1;
        }
    }
    return crc & 0x0000FFFF;
}

dword rcrc16( byte *ptr,
              dword  size,
              dword  crc )
{
    while(size-- != 0)
    {
        dword i;
        dword c=ptr[size]<<8;
        for( i=0; i<8; i++)
        {
            if( (crc^c)&0x8000 )
                crc = (crc<<1) ^ ((MAGIC16<<1)^1);
            else
                crc = (crc<<1);
            c<<=1;
        }
    }
    return crc & 0x0000FFFF;
}

dword xcrc32( byte *ptr,
              dword  size,
              dword  crc )
{
    crc = ~crc;
    while(size-- != 0)
    {
        dword i;
        dword c = *ptr++;
        for( i=0; i<8; i++)
        {
            if (((crc^c)&1)!=0)
                crc = (crc>>1) ^ MAGIC32;
            else
                crc = (crc>>1);
            c>>=1;
        }
    }
    return ~crc;
}

dword rcrc32( byte *ptr,
              dword  size,
              dword  crc )
{
    crc = ~crc;
    while(size-- != 0)
    {
        dword i;
        dword c = ptr[size]<<24;
        for( i=0; i<8; i++)
        {
            if (((crc^c)&0x80000000)!=0)
                crc = (crc<<1) ^ ((MAGIC32<<1)^1);
            else
                crc = (crc<<1);
            c<<=1;
        }
    }
    return ~crc;
}

void fuckcrc16( byte *ptr,
                dword  size,
                dword  offset,
                dword  wantcrc,
                dword  crc )
{
    *(word*)(ptr+offset) = xcrc16( ptr, offset, crc ) ^
     rcrc16( ptr+2+offset, size-(2+offset), rcrc16( (byte*)&wantcrc, 2, 0 ));
}


void fuckcrc32( byte *ptr,
                dword  size,
                dword  offset,
                dword  wantcrc,
                dword  crc )
{
    *(dword*)(ptr+offset) = xcrc32( ptr, offset, crc ) ^
     rcrc32( ptr+4+offset, size-(4+offset), rcrc32( (byte*)&wantcrc, 4, 0 ));
}

void fuckcrc48( byte *ptr,
                dword  size,
                dword  offset,
                dword  wantcrc16,
                dword  wantcrc32,
                dword  crc16,
                dword  crc32 )
{
    dword i;

    crc16 =  xcrc16( ptr, offset, crc16 );
    crc32 =  xcrc32( ptr, offset, crc32 );
    ptr+=offset;

    for( i=size-1-offset; i>=6; i--)
        wantcrc16 = rcrc16( "\x00", 1, wantcrc16 ) ^ ptr[i];

    wantcrc32 = rcrc32( ptr+6, size-(6+offset),
                         rcrc32( (byte*)&wantcrc32, 4, 0 ) );

    for( *(word*)ptr=0; ; (*(word*)ptr)++ )
    {
        *(dword*)(ptr+2) = wantcrc32 ^ xcrc32( ptr, 2, crc32 );

        if( xcrc16( ptr, 6, crc16 )==wantcrc16 ) break;
    }
}

//--example-------------------------------------------------------------

void main(int argc, char* argv[])
{
    FILE *f;
    dword size, offset, crc16, crc32;
    byte* original;

    if ((argc!=2)&&(argc!=4))
    {
      printf("CRC16/32/48 viewer/fucker\n"\
             "syntax:\n"\
             "  crc filename              -- view CRCs\n"\
             "  crc filename crc16 crc32  -- restore CRCs (last 6 bytes)\n");
      exit(0);
    }

    f = fopen(argv[1], "rb");
    assert(f);

    fseek(f,0,SEEK_END);
    size = ftell(f);
    rewind(f);

    original = (byte*)malloc(size);
    assert(original);

    fread(original, 1,size, f);
    fclose(f);

    printf("file  '%s'\n",argv[1]);
    printf("size  %i\n",size);

    if (argc==4)
    {

      sscanf(argv[2],"%04X",&crc16);
      sscanf(argv[3],"%08X",&crc32);

      offset = size-6;
      printf("offs  0x%08X\n",offset);

      printf("fucking...\n");
      fuckcrc48( original, size, offset, crc16, crc32, 0, 0 );
//    fuckcrc16( original, size, offset, crc16, 0 );
//    fuckcrc32( original, size, offset, crc32, 0 );

      assert( crc16 == xcrc16( original, size, 0 ) );
      assert( crc32 == xcrc32( original, size, 0 ) );

      printf("writing...\n");
      f = fopen(argv[1],"wb");
      assert(f);
      fwrite(original, 1,size, f);
      fclose(f);

    } // argc==4

    printf("crc16 0x%04X\n",xcrc16( original, size, 0 ));
    printf("crc32 0x%08X\n",xcrc32( original, size, 0 ));

    free(original);

}


