
f_rshift_pressed        equ     00000001b
f_lshift_pressed        equ     00000010b
f_ctrl_pressed          equ     00000100b
f_alt_pressed           equ     00001000b
f_pressed               equ     00001111b
f_caps_active           equ     01000000b

s_scroll                equ     46h
s_rshift                equ     36h

; hotkey1: eng/rus/graph
; hotkey2: dos/win/koi
; hotkey3: eng/rus

hotkey_1                equ     s_scroll+256*0                ; scroll lock
hotkey_2                equ     s_scroll+256*f_alt_pressed    ; alt+scroll lock
hotkey_3                equ     s_rshift+256*f_rshift_pressed ; right shift

                        model   tiny
                        p286

                        locals  __
                        jumps

                        .code

                        org     100h

start:
                        jmp     init

mode_color              db      0,1,10

linesize                equ     54

ascii_table             label   byte
; [rus]
db '㪥뢠஫ᬨ'  ; ---- ----- ---
db ''  ; CAPS ----- ---
db ''  ; ---- SHIFT ---
db '㪥뢠஫ᬨ'  ; CAPS SHIFT ---
db '!"/$:,.;?%-=[];''`\,./' ; ---- ----- ALT
db '!"/$:,.;?%-=[];''`\,./' ; CAPS ----- ALT
db '!"/$:,.;?%_+{}:"~|<>?'  ; ---- SHIFT ALT
db '!"/$:,.;?%_+{}:"~|<>?'  ; CAPS SHIFT ALT
; [graphix]
db '¿ҷĺ[]Ŵ׶;''н,./' ; ---- ----- ---
db '˻Ѹ[]ιص;''ʼϾ,./' ; CAPS ----- ---
db '˻Ѹ{}ιص:"ʼϾ<>?'  ; ---- SHIFT ---
db '¿ҷĺ{}Ŵ׶:"н<>?'  ; CAPS SHIFT ---
db '!"/$:,.;?%-=[];''`\,./' ; ---- ----- ALT
db '!"/$:,.;?%-=[];''`\,./' ; CAPS ----- ALT
db '!"/$:,.;?%_+{}:"~|<>?'  ; ---- SHIFT ALT
db '!"/$:,.;?%_+{}:"~|<>?'  ; CAPS SHIFT ALT

xlt_table               label   byte
; [win-1251]
db ''
db ''
db ''
db ''
; [koi8-r]
db 'ĳڿôް'
db 'ͺɸȾ̵'
db '椥娩㦢'
db ''

int09:                  pusha
                        push    ds

                        xor     cx, cx          ; get keyboard status
                        mov     ds, cx
                        mov     cl, ds:[0417h]

                        push    cs
                        pop     ds

                        mov     ah, scan_this
                        mov     scan_prev, ah

                        in      al, 60h
                        mov     scan_this, al

                        mov     bl, al
                        xor     bl, 80h
                        js      __skip
                        cmp     bl, ah
                        jne     __skip

                        mov     bh, cl
                        and     bh, f_pressed

                        irpc    c, <123>
                        cmp     bx, hotkey_&c
                        je      int09_hotkey_&c
                        endm

__skip:

                        cmp     mode, 0
                        je      int09_exit

                        test    cl, f_ctrl_pressed
                        jnz     int09_exit

                        cmp     al, linesize    ; # of scan codes per 1 line
                        jae     int09_exit

                        mov     bx, mode     ; 1/2
                        dec     bx           ; 0/1
                        imul    bx, linesize*8

                        test    cl, f_caps_active
                        jz      __1
                        add     bx, linesize

__1:
                        test    cl, f_lshift_pressed+f_rshift_pressed
                        jz      __2
                        add     bx, linesize*2
__2:
                        test    cl, f_alt_pressed
                        jz      __3
                        add     bx, linesize*4

__3:

                        add     bl, al
                        adc     bh, 0

                        mov     al, ascii_table[bx]
                        cmp     al, ''
                        je      int09_exit

                        call    translate

                        xor     ch, ch
                        mov     cl, al

                        mov     ah, 05h
                        int     16h

int09_skip:             mov     al, 20h
                        out     20h, al

                        pop     ds
                        popa

                        iret

int09_exit:             pop     ds
                        popa

                        db      0eah
old09                   dd      ?

next123                 db      1,2,0
next12                  db      1,0,0

int09_hotkey_1:         mov     bx, mode
                        mov     bl, next123[bx]
                        mov     mode, bx
                        call    apply_color
                        jmp     int09_exit

int09_hotkey_2:         mov     bx, page
                        mov     bl, next123[bx]
                        mov     page, bx
                        call    apply_font
                        jmp     int09_exit

int09_hotkey_3:         mov     bx, mode
                        mov     bl, next12[bx]
                        mov     mode, bx
                        call    apply_color
                        jmp     int09_exit

int10:                  cmp     ax, 8800h
                        je      int10_ax_8800

                        cmp     ax, 0003h
                        jbe     int10_call
                        cmp     ax, 1112h
                        je      int10_call

                        db      0eah
old10                   dd      ?

int10_call:             pushf
                        call    cs:old10
                        call    apply_color
                        call    apply_font
                        iret

int10_ax_8800:          mov     ax, 1234h
                        iret

apply_color:            push    ax
                        push    bx

                        mov     ax, 1001h       ; set border color
                        mov     bx, cs:mode
                        mov     bh, cs:mode_color[bx]
                        pushf
                        call    cs:old10

                        pop     bx
                        pop     ax
                        ret

translate:              cmp     al, 128
                        jb      __ret
                        mov     bx, cs:page
                        or      bx, bx
                        jz      __ret
                        dec     bx
                        shl     bx, 7
                        add     bl, al
                        adc     bh, 0
                        mov     al, cs:xlt_table[bx-128]
__ret:                  ret

apply_font:             pusha
                        push    ds
                        push    es

                        mov     ax, 40h
                        mov     es, ax

                        mov     cx, es:[0085h]

                        mov     bh, 3
                        cmp     cx, 8
                        je      __font

                        mov     bh, 2
                        cmp     cx, 14
                        je      __font

                        mov     bh, 6
                        cmp     cx, 16
                        jne     __ret
__font:

                        push    cx
                        mov     ax, 1130h
                        pushf
                        call    cs:old10
                        pop     cx

                        push    es
                        pop     ds
                        mov     si, bp

                        mov     ax, cx
                        shl     ax, 7
                        add     si, ax

                        push    cs
                        pop     es

                        mov     ax, 128
__makefont:
                        mov     bp, ax
                        call    translate
                        sub     ax, 128
                        cwd
                        mul     cx
                        mov     di, ax
                        add     di, offset font
                        mov     ax, bp

                        mov     bp, cx
                        shr     cx, 1
                        cld
                        rep     movsw
                        mov     cx, bp

                        inc     ax
                        or      al, al
                        jnz     __makefont

                        cmp     cs:mouse_c, 0
                        je      __skip1
                        mov     ax, 0002h       ; hide
                        pushf
                        call    cs:old33
__skip1:

                        mov     ax, 1100h
                        lea     bp, font
                        mov     bl, 0
                        mov     bh, cl
                        mov     cx, 128
                        mov     dx, 128
                        pushf
                        call    cs:old10

                        cmp     cs:mouse_c, 0
                        je      __skip2
                        mov     ax, 0001h       ; unhide
                        pushf
                        call    cs:old33
__skip2:

__ret:                  pop     es
                        pop     ds
                        popa
                        ret

int33:                  cmp     ax, 0000h
                        je      int33_ax_0000
                        cmp     ax, 0001h
                        je      int33_ax_0001
                        cmp     ax, 0002h
                        je      int33_ax_0002

int33_exit:
                        db      0eah
old33                   dd      ?

int33_ax_0000:          mov     cs:mouse_c, 0
                        jmp     int33_exit
int33_ax_0001:          inc     cs:mouse_c
                        jmp     int33_exit
int33_ax_0002:          dec     cs:mouse_c
                        jmp     int33_exit


                        even
mode                    dw      0
page                    dw      0
scan_prev               db      0
scan_this               db      0
mouse_c                 dw      0

init:

                        mov     ah, 9
                        lea     dx, msg_init
                        int     21h

                        mov     ax, 0305h       ; set keyboard speed
                        mov     bx, 0006h       ; 256 ms, 24 chars/sec
                        int     16h

                        mov     ax, 8800h
                        int     10h
                        cmp     ax, 1234h
                        je      __alredy

__install:
                        lea     si, xlt_table
                        call    xlat_table
                        lea     si, xlt_table + 128
                        call    xlat_table

                        mov     ah, 9
                        lea     dx, msg_installed
                        int     21h

hookint                 macro   xx

                        mov     ax, 35&xx&h
                        int     21h
                        mov     old&xx&.word ptr 0, bx
                        mov     old&xx&.word ptr 2, es

                        mov     ax,  25&xx&h
                        lea     dx, int&xx&
                        int     21h

                        endm

                        hookint 09
                        hookint 10
                        hookint 33

                        mov     ah, 49h
                        mov     es, ds:[002Ch]
                        int     21h

                        mov     ax, 3100h
                        mov     dx, memory
                        int     21h

__alredy:               mov     ah, 9
                        lea     dx, msg_alredy
                        int     21h

                        mov     ax, 4c00h
                        int     21h

xlat_table:             pusha

                        mov     bx, 128
__cycle:                mov     di, [bx+si-128]
                        and     di, 255
                        mov     byte ptr eof[di-128], bl
                        inc     bx
                        or      bl, bl
                        jnz     __cycle

                        mov     di, si
                        lea     si, eof
                        mov     cx, 128
                        cld
                        rep     movsb

                        popa
                        ret

msg_init                db      '- keyboard speed updated',13,10,'$'
msg_installed           db      '- installed',13,10,'$'
msg_alredy              db      '- alredy installed, exiting',13,10,'$'

eof:

                        org     init
                        even
font                    db      128*16 dup (?)
memory                  equ     ($-start+256+15)/16

                        end     start
