
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <io.h>
#include <string.h>

#include "dearmor.cpp"

void main(int argc, char* argv[])
{
  printf("PGPDUMP  version 1.00  (x) 2000 Z0MBiE  http://z0mbie.cjb.net\n");

  if (argc!=2)
  {
    printf("syntax: PGPDUMP filename\n");
    exit(0);
  }

  FILE*f=fopen(argv[1],"rb");
  if (f==NULL)
  {
    printf("***ERROR***: can't open file %s\n", argv[1]);
    exit(0);
  }
  printf("- processing %s\n", argv[1]);
  int isize=filelength(fileno(f));
  char* ibuf=(char*)malloc(isize+1);
  ibuf[isize]=0;
  printf("- reading %i bytes\n", isize);
  fread(ibuf, 1,isize, f);
  fclose(f);

  char *x=ibuf, *maxx=ibuf+isize;

  char *c=x;
  while (c && *c)
  {
    if ((!(c[0]&0x80))&&(strchr(c,13)-c==64))
    {
      printf("- found ascii data at offset 0x%08X\n", c - x);
      char* obuf=(char*)malloc((isize*3+3)/4);
      int osize;
      darmor_buffer(c, obuf, &osize);
      printf("- converted into binary, %i bytes\n", osize);
      x=obuf;
      maxx=obuf+osize;
      break;
    }
    c++;
  }

  printf("- processing data\n");

  while (x<maxx)
  {
    int i=*x++;
    if (i&0x80)
    {
      int len=1<<(i&3);
      if (len==1) { len=*x; x+=1; } else
      if (len==2) { len=*(short*)x; x+=2; len=((len&0xFF)<<8)|((len&0xFF00)>>8); } else
      if (len==4) { len=*(long*)x; x+=4; len=((len&0xFF)<<24)|((len&0xFF00)<<8)|((len&0xFF0000)>>8)|((len&0xFF000000)>>24); } else
      if (len==8) len=0;
      int typ=(i>>2)&0x0F;
      printf("- CTB type=%i%i%i%ib/0x%02X, len=%i\n", (i>>5)&1,(i>>4)&1,(i>>3)&1,(i>>2)&1, typ, len);
      switch (typ)
      {
        case 0x01: printf("  public-key-encrypted packet\n");
                   break;
        case 0x02: printf("  secret-key-encrypted (signature) packet\n");
                   break;
        case 0x05: printf("  Secret key certificate\n");
                   break;
        case 0x06: {
                   char*x0=x;
                   printf("  public key certificate\n");
                   printf("  version=%i\n",*x++);
                   printf("  timestamp=%08X\n",*(unsigned long*)x); x+=4;
                   printf("  validity period=%i days (0=forever)\n", *(unsigned short*)x); x+=2;
                   printf("  algorithm=%i (1=RSA)\n",*x++);
                   break;
                   }
        case 0x08: printf("  Compressed data packet\n");
                   break;
        case 0x09: printf("  Conventional-Key-Encrypted data\n");
                   break;
        case 0x0B: printf("  Raw literal plaintext data, with filename and mode\n");
                   break;
        case 0x0C: printf("  Keyring trust packet\n");
                   break;
        case 0x0D: {
                   printf("  user ID packet, associated with public or secret key\n");
                   char s[256];
                   memcpy(s, x, len);
                   s[len]=0;
                   printf("  [%s]\n", s);
                   break;
                   }
        case 0x0E: printf("  Comment packet\n");
                   break;
        default:   printf("  unknown type\n");
      }

      x+=len;
    }
    else
    {
      printf("- CTB not found (0x%02X)\n", i&255);
      exit(0);
    }
  }

}
