
#define WINAMPX_SERVER_PORT    1
#define WINAMPX_CLIENT_PORT    2
#define MAX_MSG_LEN            512
#define REPLY_TIMEOUT          5

#define cmd_ok(buf,len)  ((len>=2)&&(len<=MAX_MSG_LEN)&&(buf[len-1]==0x00))

char* do_cmd(char* host, char* cmd, int use_wsa)
{
  char* result = NULL;

  int len = strlen(cmd)+1;
  if (len > MAX_MSG_LEN)
  {
    printf_err("ERROR:max cmd size is %i bytes\n", MAX_MSG_LEN);
  }
  else
  {

    WSADATA WSAData;
    if ( use_wsa && (WSAStartup(MAKEWORD(1,1), &WSAData) != 0) )
    {
      printf_err("ERROR:WSAStartup() error %i\n", WSAGetLastError());
    }
    else
    {

      DWORD ip = inet_addr(host);
      if (ip == INADDR_NONE)
      {
        hostent* he = gethostbyname(host);
        if ((he == NULL) || (he->h_addrtype != AF_INET))
        {
          printf_err("ERROR:gethostbyname() error %i\n", WSAGetLastError());
        }
        else
        {
          ip = *(DWORD*)he->h_addr_list[0];
        }
      }

      if (ip != INADDR_NONE)
      {

        SOCKET s = socket(AF_INET, SOCK_DGRAM, IPPROTO_IP);
        if (s == INVALID_SOCKET)
        {
          printf_err("ERROR:socket() error %i\n", WSAGetLastError());
        }
        else
        {

          static sockaddr_in src_addr;
          src_addr.sin_family      = AF_INET;
          src_addr.sin_port        = htons(WINAMPX_CLIENT_PORT);
          src_addr.sin_addr.s_addr = INADDR_ANY;

          if (bind(s, (sockaddr*)&src_addr, sizeof(src_addr)) != 0)
          {
            printf_err("ERROR:bind() error %i\n", WSAGetLastError());
          }
          else
          {
            static sockaddr_in dst_addr;
            dst_addr.sin_family      = AF_INET;
            dst_addr.sin_port        = htons(WINAMPX_SERVER_PORT);
            dst_addr.sin_addr.s_addr = ip;

            int res = sendto(s, cmd, len, 0, (sockaddr*)&dst_addr, sizeof(dst_addr));
            if (res != len)
            {
              printf_err("ERROR:sendto()=%i, WSAGetLastError()=%i\n", res, WSAGetLastError());
            }
            else
            {

              struct timeval tm = {REPLY_TIMEOUT,0};
              static fd_set readfds;
              FD_ZERO(&readfds);
              FD_SET(s, &readfds);
              res = select(1, &readfds,0,0, &tm);
              if (res == SOCKET_ERROR)
              {
                printf_err("ERROR:select() error %i\n", WSAGetLastError());
              }
              else
              if (res == 0)
              {
                printf_err("server reply timeout\n");
              }
              else
              {

                static BYTE buf[MAX_MSG_LEN];
                int len = recv(s, buf, MAX_MSG_LEN, 0);
                if ((len==0)||(len==SOCKET_ERROR))
                {
                  printf_err("ERROR:recv()=%i, error %i\n", len, WSAGetLastError());
                }
                else
                {
                  if (!cmd_ok(buf,len))
                  {
                    printf_err("ERROR:invalid reply packet\n");
                  }
                  else
                  {
                    result = (char*)malloc(len);
                    memcpy(result, buf, len);
                  } // packet ok

                } // recv

              } // select

            } // sendto

          } // bind

          closesocket(s);

        } // socket()

      } // ip

    } // WSAStartup()

    if (use_wsa)
      WSACleanup();

  } // cmd ok

  return result;
} // do_cmd()
