<?php
include("./header.php");


$key = checkStr($_GET["key"]);
$guest = R::findOne('guest', 'link_key = ?', [$key]);

function checkStr($str){
    $str = strip_tags($str);
    $str = filter_var($str);
    return $str;
}
$tag = $guest['tag'];



?>

<body>
    <main class="container-xl">
        <div class="row px-4">
            <h5 class="page-title">Guest dashboard - Mars</h5>
        </div>
        <div class="row px-3">
            <div class="col-md-6 col-lg-3">
                <div class="card report-card">
                    <div class="card-body">
                        <div class="row d-flex justify-content-center">
                            <div class="col">
                                <p class="text-dark mb-0 font-weight-semibold">Total log</p>
                                <h3 class="m-0"><?php

                                    echo R::count("log", "tag = ?",[$tag]);
                                    ?></h3>
                                <p class="mb-0 text-truncate text-muted">During all this time</p>
                            </div>
                            <div class="col-auto align-self-center">
                                <div class="report-main-icon bg-light-alt">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bar-chart-fill" viewBox="0 0 16 16">
  <path d="M1 11a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1v-3zm5-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v7a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1V7zm5-5a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1V2z"/>
</svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end card-body-->
                </div>
                <!--end card-->
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="card report-card">
                    <div class="card-body">
                        <div class="row d-flex justify-content-center">
                            <div class="col">
                                <p class="text-dark mb-0 font-weight-semibold">Last week</p>
                                <h3 class="m-0">
                                    <?php
                                    $currentDate = new DateTime(date("Y-m-d"));
                                    $currentDate->modify("-7 day");
                                    $countCurrentWeek = R::count("log", "tag = :tag AND add_date > :currentDate", [":currentDate" => date_format($currentDate, "Y-m-d"), ":tag" => $tag]);
                                    echo $countCurrentWeek;
                                    $range1 = new DateTime(date("Y-m-d"));
                                    $range2 = new DateTime(date("Y-m-d"));
                                    $range1->modify("-7 day");
                                    $range2->modify("-14 day");
                                    $countLastWeek = R::count("log", "tag = :tag AND add_date BETWEEN :date1 AND :date2", [":date1" => date_format($range2, "Y-m-d"), ":date2" => date_format($range1, "Y-m-d"), ":tag" => $tag]);
                                    $icon = 'text-success';
                                    if ($countCurrentWeek - $countLastWeek < 0) {
                                        $icon = 'text-danger';
                                    }
                                    ?>
                                </h3>
                                <p class="mb-0 text-truncate text-muted"><span class="<?php echo $icon ?>">
                                                <svg viewBox="0 0 24 24" width="12" height="12" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1">
                                                    <line x1="7" y1="7" x2="17" y2="17"></line>
                                                    <polyline points="17 7 17 17 7 17"></polyline>
                                                </svg>
                                                <?php
                                                echo $countCurrentWeek - $countLastWeek;
                                                ?>
                                            </span> Than the
                                    previous
                                </p>
                            </div>
                            <div class="col-auto align-self-center">
                                <div class="report-main-icon bg-light-alt">
                                    <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1">
                                        <circle cx="12" cy="12" r="10"></circle>
                                        <polyline points="12 6 12 12 16 14"></polyline>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end card-body-->
                </div>
                <!--end card-->
            </div>
            <!--end col-->
            <div class="col-md-6 col-lg-3">
                <div class="card report-card">
                    <div class="card-body">
                        <div class="row d-flex justify-content-center">
                            <div class="col">
                                <p class="text-dark mb-0 font-weight-semibold">Last 30d</p>
                                <h3 class="m-0">
                                    <?php
                                    $currentDate = new DateTime(date("Y-m-d"));
                                    $currentDate->modify("-1 month");
                                    $countCurrentMonth = R::count("log", "tag = :tag AND add_date > :currentDate", [":currentDate" => date_format($currentDate, "Y-m-d"), ":tag" => $tag]);
                                    echo $countCurrentMonth;
                                    $range1 = new DateTime(date("Y-m-d"));
                                    $range2 = new DateTime(date("Y-m-d"));
                                    $range1->modify("-1 month");
                                    $range2->modify("-2 month");
                                    $countLastMonth = R::count("log", "add_date BETWEEN :date1 AND :date2 AND tag = :tag", [":date1" => date_format($range2, "Y-m-d"), ":date2" => date_format($range1, "Y-m-d"), ":tag" => $tag]);
                                    if ($countCurrentMonth - $countLastMonth < 0) {
                                        $icon = 'text-danger';
                                    }
                                    ?>
                                </h3>
                                <p class="mb-0 text-truncate text-muted"><span class="<?php echo $icon ?>">
                                                <svg viewBox="0 0 24 24" width="12" height="12" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1">
                                                    <line x1="7" y1="7" x2="17" y2="17"></line>
                                                    <polyline points="17 7 17 17 7 17"></polyline>
                                                </svg>
                                                <?php
                                                echo $countCurrentMonth - $countLastMonth;
                                                ?>
                                            </span> Than the
                                    previous
                                </p>
                            </div>
                            <div class="col-auto align-self-center">
                                <div class="report-main-icon bg-light-alt">
                                    <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1">
                                        <polyline points="22 12 18 12 15 21 9 3 6 12 2 12"></polyline>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end card-body-->
                </div>
                <!--end card-->
            </div>
            <!--end col-->
            <div class="col-md-6 col-lg-3">
                <div class="card report-card">
                    <div class="card-body">
                        <div class="row d-flex justify-content-center">
                            <div class="col">
                                <p class="text-dark mb-0 font-weight-semibold">Total pass</p>
                                <h3 class="m-0">
                                    <?php
                                    $count = R::getRow('SELECT SUM(count_pwds) FROM log WHERE tag = :tag', [":tag" => $tag]);

                                    echo ($count["SUM(count_pwds)"] == NULL?0:$count["SUM(count_pwds)"]);
                                    ?>
                                </h3>
                                <p class="mb-0 text-truncate text-muted">
                                    During all this time</p>
                            </div>
                            <div class="col-auto align-self-center">
                                <div class="report-main-icon bg-light-alt">
                                    <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1">
                                        <rect x="2" y="7" width="20" height="14" rx="2" ry="2"></rect>
                                        <path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16"></path>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end card-body-->
                </div>
                <!--end card-->
            </div>
        </div>
        <div class="row px-3">
            <div class="col-md-9">
                <div class="card">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col">
                                <h4 class="card-title">Chronology Overview</h4>
                            </div>
                        </div>
                        <!--end row-->
                    </div>
                    <!--end card-header-->
                    <div class="card-body">
                        <div class="">
                            <div id="ana_dash_1" class="apex-charts"></div>
                        </div>
                    </div>
                    <!--end card-body-->
                </div>
                <div class="row">
                    <div class=" col-lg-3">
                        <div class="card report-card">
                            <div class="card-body">
                                <div class="row d-flex justify-content-center">
                                    <div class="col">
                                        <p class="text-dark mb-0 font-weight-semibold">Total crypto</p>
                                        <h3 class="m-0"><?php
                                            $count = R::getRow('SELECT SUM(count_crpt) FROM log WHERE tag = :tag', [":tag" => $tag]);
                                            echo ($count["SUM(count_crpt)"] == NULL?0:$count["SUM(count_crpt)"]);
                                            ?></h3>
                                        <p class="mb-0 text-truncate text-muted">During all this time</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class=" col-lg-3">
                        <div class="card report-card">
                            <div class="card-body">
                                <div class="row d-flex justify-content-center">
                                    <div class="col">
                                        <p class="text-dark mb-0 font-weight-semibold">Total plugins</p>
                                        <h3 class="m-0"><?php
                                            $count = R::getRow('SELECT SUM(count_plugins) FROM log WHERE tag = :tag', [":tag" => $tag]);
                                            echo ($count["SUM(count_plugins)"] == NULL?0:$count["SUM(count_plugins)"]);
                                            ?></h3>
                                        <p class="mb-0 text-truncate text-muted">During all this time</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class=" col-lg-3">
                        <div class="card report-card">
                            <div class="card-body">
                                <div class="row d-flex justify-content-center">
                                    <div class="col">
                                        <p class="text-dark mb-0 font-weight-semibold">Total telegram</p>
                                        <h3 class="m-0"><?php
                                            $count = R::getRow('SELECT SUM(count_telegram) FROM log WHERE tag = :tag', [":tag" => $tag]);
                                            echo ($count["SUM(count_telegram)"] == NULL?0:$count["SUM(count_telegram)"]);
                                            ?></h3>
                                        <p class="mb-0 text-truncate text-muted">During all this time</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class=" col-lg-3">
                        <div class="card report-card">
                            <div class="card-body">
                                <div class="row d-flex justify-content-center">
                                    <div class="col">
                                        <p class="text-dark mb-0 font-weight-semibold">Total discord</p>
                                        <h3 class="m-0"><?php
                                            $count = R::getRow('SELECT SUM(count_discord) FROM log WHERE tag = :tag', [":tag" => $tag]);
                                            echo ($count["SUM(count_discord)"] == NULL?0:$count["SUM(count_discord)"]);
                                            ?></h3>
                                        <p class="mb-0 text-truncate text-muted">During all this time</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col">
                                <h4 class="card-title">Сountry logs</h4>
                            </div>
                        </div>
                        <!--end row-->
                    </div>
                    <!--end card-header-->
                    <div class="card-body">
                        <div class="text-center">
                            <div id="ana_device" class="apex-charts"></div>

                        </div>
                        <div class="table-responsive mt-2" style=" max-height: 210px;">
                            <table class="table border-dashed mb-0">
                                <thead>
                                <tr>
                                    <th>Сountry</th>
                                    <th>Code</th>
                                    <th>Logs</th>

                                </tr>
                                </thead>

                            
                                    <tbody >
                                        <?php
                                            $countries = R::getAll('SELECT country, COUNT(*) as count FROM log WHERE tag = :tag GROUP BY country ORDER BY count DESC', [":tag" => $tag]);
                                            $countryNames = R::getAll('SELECT name, code FROM statistics_countries');
                                            
                                            foreach ($countries as $country) {
                                                foreach($countryNames as $countryName)
                                                {
                                                    if($countryName["code"] == $country["country"]){
                                                        echo '<tr>
                                                            <td>' . $countryName["name"] . '</td>
                                                            <td>' . $country["country"] . '</td>
                                                            <td>' . $country['count'] . '</td>
                                                        </tr>';
                                                    }
                                                    

                                                }
                                                
                                            }
                                        ?>                                                        
                                    </tbody>
                                
                            </table>
                            <!--end /table-->
                        </div>
                        <!--end /div-->
                    </div>
                    <!--end card-body-->
                </div>
                <!--end card-->
            </div>
        </div>
        <div class="row px-4">
            <h5>Last 40 logs</h5>
            <div class="table-responsive">
                <table class="table table-striped table-sm">

                    <thead>
                    <tr>
                        <th scope="col">ID</th>
                        <th scope="col">IP</th>
                        <th scope="col">Country</th>
                        <th scope="col">Passwords</th>
                        <th scope="col">Crypto</th>
                        <th scope="col">Plugins</th>
                        <th scope="col">Telegram</th>
                        <th scope="col">Discord</th>
                        <th scope="col">Date</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $logs = R::getAll('SELECT * FROM log WHERE tag = :tag ORDER BY id DESC LIMIT 40', [":tag" => $tag]);

                    foreach ($logs as $log){
                        echo '<tr>
                        <td>'.$log["id"].'</td>
                        <td>'.$log["ip"].'</td>
                        <td>'.$log["country"].'</td>
                        <td>'.$log["count_pwds"].'</td>
                        <td>'.$log["count_crpt"].'</td>
                        <td>'.$log["count_plugins"].'</td>
                        <td>'.$log["count_telegram"].'</td>
                        <td>'.$log["count_discord"].'</td>            
                        <td>'.$log["add_date"].'</td>
                    </tr>';
                    }
                    ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/apexcharts.min.js"></script>
    <script src="assets/js/jquery.analytics_dashboard.init.js"></script>

    <!-- App js -->
</body>
